﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    [Serializable]
    [XmlType(TypeName = "BedDNDAndOOS")]
    [DataContract(Name = "BedDNDAndOOS")]    
    [KnownType(typeof(II))]    
    public class BedDNDAndOOS
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        [XmlElementAttribute("BedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 1)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is unavailable from vista.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is unavailable from vista; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsUnavailableFromVista", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "IsUnavailableFromVista", Order = 2)]
        public bool IsUnavailableFromVista { get; set; }

        /// <summary>
        /// Gets or sets the unavailable type code.
        /// </summary>
        /// <value>
        /// The unavailable type code.
        /// </value>
        [XmlElementAttribute("UnavailableTypeCode", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "UnavailableTypeCode", Order = 3)]
        public string UnavailableTypeCode { get; set; }
    }
}
